function [] = plot_prof(time,battery,EPowers,ElectricEnergy,cabin)
% Plot the results obtained by the thermal management
fig_num = 1;
% Plot configurations
fs = 20; % font size
lw = 2; % line width
scatter_size = 40;

%% Battery
% Current 
figure(fig_num)
subplot(2,1,1); hold on; box on;
plot(time,battery.i_tot,'LineWidth',lw), grid on
ylabel('i_{battery} (A)');
xlim([0,inf])
% Compressor power
subplot(2,1,2); hold on; box on;
plot(time,EPowers.Compressor./1000,'LineWidth',lw), grid on
hold on
plot(time,EPowers.Fan./1000,'--','LineWidth',lw), grid on
hold on
plot(time,EPowers.MotorPump./1000,'-.','LineWidth',lw), grid on
hold on
plot(time,EPowers.BatteryPump./1000,':','LineWidth',lw), grid on
xlabel('Time (s)'), ylabel('EPower (kW)'), legend('Compressor','Fan','Motor Pump','Battery Pump')
xlim([0,inf])
set(findall(gcf,'-property','FontSize'),'FontSize',fs)

% battery temperature
fig_num = fig_num + 1;
figure(fig_num); 
subplot(2,1,1); hold on; box on;
plot(time,battery.T,'LineWidth',lw)
ylabel('T_{battery} (°C)')
xlim([0,inf])

subplot(2,1,2); hold on; box on;
plot(time,EPowers.Compressor./1000,'LineWidth',lw)
xlabel('Time (s)'), ylabel('P_{comp} (kW)')
xlim([0,inf])
set(findall(gcf,'-property','FontSize'),'FontSize',fs)



% battery current
fig_num = fig_num + 1;
figure(fig_num); hold on; box on;
plot(time,battery.i_tot,'LineWidth',lw)
xlabel('Time (s)'), ylabel('i_{battery} (A)')
xlim([0,inf])
set(findall(gcf,'-property','FontSize'),'FontSize',fs)


%% Energy consumption
% Compressor power consumption
fig_num = fig_num + 1;
figure(fig_num); 
subplot(2,1,1); hold on; box on;
plot(time,ElectricEnergy.battery_BTM_compressor/(3600*1000),'LineWidth',lw)
ylabel('E_{comp} (kWh)')
xlim([0,inf])
subplot(2,1,2); hold on; box on;
plot(time,ElectricEnergy.battery_BTM_fan/(3600*1000),'LineWidth',lw)
xlabel('Time (s)'), ylabel('E_{fan} (kWh)')
xlim([0,inf])
set(findall(gcf,'-property','FontSize'),'FontSize',fs)

% BTM total power consumption
fig_num = fig_num + 1;
figure(fig_num); hold on; box on;
plot(time,ElectricEnergy.battery_BTM/(3600*1000),'LineWidth',lw)
xlabel('Time (s)'), ylabel('E_{BTM} (kWh)')
xlim([0,inf])
set(findall(gcf,'-property','FontSize'),'FontSize',fs)

% Total energy consumption of the vehicle
fig_num = fig_num + 1;
figure(fig_num); hold on; box on;
plot(time,ElectricEnergy.battery_tot/(3600*1000),'LineWidth',lw)
xlabel('Time (s)'), ylabel('E (kWh)')
xlim([0,inf])
set(findall(gcf,'-property','FontSize'),'FontSize',fs)


%% HVAC 
if exist('cabin')
    %% Cabin 
    fig_num = fig_num + 1;
    figure(fig_num); hold on; box on;
    plot(time,cabin.T_cabin,'LineWidth',lw)
    xlabel('Time (s)'), ylabel('T_{cabin} (°C)')
    xlim([0,inf])
    set(findall(gcf,'-property','FontSize'),'FontSize',fs)
    
    %% Heat exchanges
    % Qjoule vs Q_BTM
    fig_num = fig_num + 1;
    figure(fig_num)
    subplot(4,1,1); hold on; box on;
    plot(time,EPowers.Compressor./1000,'LineWidth',lw)
    xlabel('Time (s)'), ylabel('P_{comp} (kW)')
    xlim([0,inf])
    subplot(4,1,2); hold on; box on;
    plot(time,battery.coolant_Q_BMS./1000,'LineWidth',lw)
    xlabel('Time (s)'), ylabel('Q_{BTM} (kW)')
    xlim([0,inf])
    subplot(4,1,3); hold on; box on;
    plot(time,cabin.Q_cabin_HVAC./1000,'LineWidth',lw)
    xlabel('Time (s)'), ylabel('Q_{HVAC} (kW)')
    xlim([0,inf])
    subplot(4,1,4); hold on; box on;
    plot(time,cabin.mdot_blower./1000,'LineWidth',lw)
    xlabel('Time (s)'), ylabel('m_{blower} (kg/s)')
    xlim([0,inf])
    set(findall(gcf,'-property','FontSize'),'FontSize',fs)

    % Q convection and convective coefficient
    if isfield(cabin,'Q_cabin_convection')
        fig_num = fig_num + 1;
        figure(fig_num)
        subplot(2,1,1); hold on; box on;
        plot(time,cabin.Q_cabin_convection/1000,'LineWidth',lw)
        ylabel('Q_{cabin,convection} (kW)')
        delta_T = battery.T_env - cabin.T_cabin;
        h = cabin.Q_cabin_convection ./  delta_T;
        subplot(2,1,2); hold on; box on;
        plot(time,h,'LineWidth',lw)
        xlabel('Time (s)'), ylabel('h (W/Ks)')
        set(findall(gcf,'-property','FontSize'),'FontSize',fs)
    end
    
    % Battery cooling (Q_BMS)
    fig_num = fig_num + 1;
    figure(fig_num); 
    scatter3(battery.mdot_coolant,cabin.mdot_blower,EPowers.Compressor./1000,...
        scatter_size,battery.coolant_Q_BMS/1000,'filled')
    xlabel('$\dot{m}_{coolant}$ (kg/s)', 'Interpreter', 'latex')
    ylabel('$\dot{m}_{blower}$ (kg/s)', 'Interpreter', 'latex')
    zlabel('P_{comp} (kW)')
    hold on;
    cb = colorbar;                                     % create and label the colorbar
    cb.Label.String = 'Q_{BMS} (kW)';

    % Battery cooling (Q_BMS)
    fig_num = fig_num + 1;
    figure(fig_num); 
    scatter3(battery.mdot_coolant,battery.T_env,EPowers.Compressor./1000,...
        scatter_size,battery.coolant_Q_BMS/1000,'filled')
    xlabel('$\dot{m}_{coolant}$ (kg/s)', 'Interpreter', 'latex')
    ylabel('T_{env} (°C)')
    zlabel('P_{comp} (kW)')
    hold on;
    cb = colorbar;                                     % create and label the colorbar
    cb.Label.String = 'Q_{BMS} (kW)';
    
    % Cabin cooling (Q_HVAC)
    fig_num = fig_num + 1;
    figure(fig_num); 
    scatter3(battery.mdot_coolant,cabin.mdot_blower,EPowers.Compressor./1000,...
        scatter_size,cabin.Q_cabin_HVAC/1000,'filled')
    xlabel('$\dot{m}_{coolant}$ (kg/s)', 'Interpreter', 'latex')
    ylabel('$\dot{m}_{blower}$ (kg/s)', 'Interpreter', 'latex')
    zlabel('P_{comp} (kW)')
    hold on;
    cb = colorbar;                                     % create and label the colorbar
    cb.Label.String = 'Q_{HVAC} (kW)';

    % Cabin cooling (Q_HVAC)
    fig_num = fig_num + 1;
    figure(fig_num); 
    scatter3(cabin.T_cabin,cabin.mdot_blower,EPowers.Compressor./1000,...
        scatter_size,cabin.Q_cabin_HVAC/1000,'filled')
    xlabel('T_{cabin} (°C)')
    ylabel('$\dot{m}_{blower}$ (kg/s)', 'Interpreter', 'latex')
    zlabel('P_{comp} (kW)')
    hold on;
    cb = colorbar;                                     % create and label the colorbar
    cb.Label.String = 'Q_{HVAC} (kW)';

    % Cabin cooling (Q_HVAC)
    fig_num = fig_num + 1;
    figure(fig_num); 
    scatter3(battery.T_env,cabin.mdot_blower,EPowers.Compressor./1000,...
        scatter_size,cabin.Q_cabin_HVAC/1000,'filled')
    xlabel('T_{env} (°C)')
    ylabel('$\dot{m}_{blower}$ (kg/s)', 'Interpreter', 'latex')
    zlabel('P_{comp} (kW)')
    hold on;
    cb = colorbar;                                     % create and label the colorbar
    cb.Label.String = 'Q_{HVAC} (kW)';

    % Cabin cooling (Q_HVAC)
    fig_num = fig_num + 1;
    figure(fig_num); 
    scatter3(battery.coolant_Q_BMS/1000,cabin.mdot_blower,EPowers.Compressor./1000,...
        scatter_size,cabin.Q_cabin_HVAC/1000,'filled')
    xlabel('Q_{BMS} (kW)')
    ylabel('$\dot{m}_{blower}$ (kg/s)', 'Interpreter', 'latex')
    zlabel('P_{comp} (kW)')
    hold on;
    cb = colorbar;                                     % create and label the colorbar
    cb.Label.String = 'Q_{HVAC} (kW)';
    

    % Battery and cabin cooling (Q_BMS + Q_HVAC)
    fig_num = fig_num + 1;
    figure(fig_num); 
    scatter(EPowers.Compressor./1000,battery.coolant_Q_BMS/1000+cabin.Q_cabin_HVAC/1000)
    xlabel('P_{comp} (kW)')
    ylabel('Q_{BMS} + Q_{HVAC} (kW)')
    hold on;

    fig_num = fig_num + 1;
    figure(fig_num); 
    subplot(2,1,1);
    scatter(EPowers.Compressor./1000,cabin.Q_cabin_HVAC/1000)
    ylabel(' Q_{HVAC} (kW)')
    subplot(2,1,2);
    scatter(EPowers.Compressor./1000,battery.coolant_Q_BMS/1000)
    xlabel('P_{comp} (kW)')
    ylabel('Q_{BMS} (kW)')
    hold on;

end

% Working points on the plain (p-h)

% %% Compressor
% % Volumentric efficiency
% figure()
% plot(compressor_reactive_Tenv20.VolumetricEfficiency.time,compressor_reactive_Tenv20.VolumetricEfficiency,'Color',"b")
% hold on, grid on
% plot(compressor_reactiveNCB_Tenv20.VolumetricEfficiency.time,compressor_reactiveNCB_Tenv20.VolumetricEfficiency,'Color',"r")
% hold on 
% plot(compressor.VolumetricEfficiency.time,compressor.VolumetricEfficiency,'Color',"k")
% xlabel("Time (s)")
% ylabel("{\eta}_v")
% title("Compressor Volumetric Efficiency at T_{env} = 20°C")
% legend('Reactive','Reactive NCB','AMPC')
% 
% % mdot
% figure()
% plot(compressor_reactive_Tenv20.fluid.mdot.in.time,compressor_reactive_Tenv20.fluid.mdot.in,'Color',"b"), grid on
% hold on
% plot(compressor_reactiveNCB_Tenv20.fluid.mdot.in.time,compressor_reactiveNCB_Tenv20.fluid.mdot.in,'Color',"r"), grid on
% hold on
% plot(compressor.fluid.mdot.in.time,compressor.fluid.mdot.in,'Color',"k"), grid on
% xlabel("Time (s)")
% ylabel('$\dot{m}$ (kg/s)', 'Interpreter','latex')
% title('Compressor Mass Flow Rate at T_{env} = 20°C')
% legend('Reactive','Reactive NCB','AMPC')
% 
% % p_in vs p_out
% figure(2)
% subplot(2,1,1)
% plot(compressor_reactive_Tenv20.fluid.p.out.time,compressor_reactive_Tenv20.fluid.p.out,'Color',"b"), grid on
% hold on
% plot(compressor_reactiveNCB_Tenv20.fluid.p.out.time,compressor_reactiveNCB_Tenv20.fluid.p.out,'Color',"r"), grid on
% hold on
% plot(compressor.fluid.p.out.time,compressor.fluid.p.out,'Color',"k"), grid on
% xlabel("Time (s)")
% ylabel("p_{out} (MPa)")
% title('Compressor outlet pressure at T_{env} = 20°C')
% legend('Reactive','Reactive NCB','AMPC')
% 
% subplot(2,1,2) % p in comp
% plot(compressor_reactive_Tenv20.fluid.p.in.time,compressor_reactive_Tenv20.fluid.p.in,'Color',"b"), grid on
% hold on
% plot(compressor_reactiveNCB_Tenv20.fluid.p.in.time,compressor_reactiveNCB_Tenv20.fluid.p.in,'Color',"r"), grid on
% hold on
% plot(compressor.fluid.p.in.time,compressor.fluid.p.in,'Color',"k"), grid on
% xlabel("Time (s)")
% ylabel("p_{in} (MPa)")
% title('Compressor intlet pressure at T_{env} = 20°C')
% legend('Reactive','Reactive NCB','AMPC')
% 
% 
% % mdot vs Tout vs Tin
% figure(3)
% subplot(2,1,1)
% plot(compressor_reactive_Tenv20.fluid.T.out.time,compressor_reactive_Tenv20.fluid.T.out,'Color',"b")
% hold on, grid on
% plot(compressor_reactiveNCB_Tenv20.fluid.T.out.time,compressor_reactiveNCB_Tenv20.fluid.T.out,'Color',"r")
% hold on
% plot(compressor.fluid.T.out.time,compressor.fluid.T.out,'Color',"k")
% xlabel("Time (s)")
% ylabel("T_{out} (K)")
% title('Compressor outlet temperature at T_{env} = 20°C')
% legend('Reactive','Reactive NCB','AMPC')
% 
% subplot(2,1,2)
% plot(compressor_reactive_Tenv20.fluid.T.in.time,compressor_reactive_Tenv20.fluid.T.in,'Color',"b")
% hold on, grid on
% plot(compressor_reactiveNCB_Tenv20.fluid.T.in.time,compressor_reactiveNCB_Tenv20.fluid.T.in,'Color',"r")
% hold on
% plot(compressor.fluid.T.in.time,compressor.fluid.T.in,'Color',"k")
% xlabel("Time (s)")
% ylabel("T_{in} (K)")
% title('Compressor inlet temperature at T_{env} = 20°C')
% legend('Reactive','Reactive NCB','AMPC')
% 
% 
% 
% % mdot vs v_out vs v_in 
% figure(4)
% subplot(2,1,1)
% plot(compressor_reactive_Tenv20.fluid.v.out.time,compressor_reactive_Tenv20.fluid.v.out,'Color',"b")
% hold on, grid on
% plot(compressor_reactiveNCB_Tenv20.fluid.v.out.time,compressor_reactiveNCB_Tenv20.fluid.v.out,'Color',"r")
% hold on 
% plot(compressor.fluid.v.out.time,compressor.fluid.v.out,'Color',"k")
% xlabel("Time (s)")
% ylabel("v_{out} (K)")
% title('Compressor outlet Specific Volume at T_{env} = 20°C')
% legend('Reactive','Reactive NCB','AMPC')
% 
% subplot(2,1,2)
% plot(compressor_reactive_Tenv20.fluid.v.in.time,compressor_reactive_Tenv20.fluid.v.in,'Color',"b")
% hold on, grid on
% plot(compressor_reactiveNCB_Tenv20.fluid.v.in.time,compressor_reactiveNCB_Tenv20.fluid.v.in,'Color',"r")
% hold on 
% plot(compressor.fluid.v.in.time,compressor.fluid.v.in,'Color',"k")
% xlabel("Time (s)")
% ylabel("v_{in} (K)")
% title('Compressor inlet Specific Volume at T_{env} = 20°C')
% legend('Reactive','Reactive NCB','AMPC')
% 
% 
% % vapor quality
% figure()
% subplot(2,1,1)
% plot(compressor_reactive_Tenv20.fluid.x.out.time,compressor_reactive_Tenv20.fluid.x.out,'Color','b')
% hold on, grid on
% plot(compressor_reactiveNCB_Tenv20.fluid.x.out.time,compressor_reactiveNCB_Tenv20.fluid.x.out,'Color','r')
% hold on
% plot(compressor.fluid.x.out.time,compressor.fluid.x.out,'Color','k')
% xlabel('Time (s)')
% ylabel('x_{out}'), title('Compressor Outlet Vapor Quality at T_{env} = 20°C ')
% legend('Reactive','Reactive NCB','AMPC')
% 
% subplot(2,1,2)
% plot(compressor_reactive_Tenv20.fluid.x.in.time,compressor_reactive_Tenv20.fluid.x.in,'Color','b')
% hold on, grid on
% plot(compressor_reactiveNCB_Tenv20.fluid.x.in.time,compressor_reactiveNCB_Tenv20.fluid.x.in,'Color','r')
% hold on
% plot(compressor.fluid.x.out.time,compressor.fluid.x.out,'Color','k')
% xlabel('Time (s)')
% ylabel('x_{in}'), title('Compressor Inlet Vapor Quality at T_{env} = 20°C ')
% legend('Reactive','Reactive NCB','AMPC')
% 
% 
% 
% %% condenser
% 
% %efficiency
% figure(11)
% plot(condenser_reactive_Tenv20.efficiency.effCoeff.time,condenser_reactive_Tenv20.efficiency.effCoeff,'color','b')
% hold on, grid on
% plot(condenser_reactiveNCB_Tenv20.efficiency.effCoeff.time,condenser_reactiveNCB_Tenv20.efficiency.effCoeff,'color','r')
% hold on 
% plot(condenser.efficiency.effCoeff.time,condenser.efficiency.effCoeff,'color','k')
% xlabel('Time (s)')
% ylabel('\epsilon_{cond}')
% title('Condenser Efficiency')
% legend('Reactive','ReactiveNCB','AMPC')
% % return
% 
% %% chiller
% %efficiency
% figure(20)
% plot(chiller.efficiency.effCoeff.time,chiller.efficiency.effCoeff,'color','k')
% hold on, grid on
% plot(chiller_reactive_Tenv20.efficiency.effCoeff.time,chiller_reactive_Tenv20.efficiency.effCoeff,'color','b')
% hold on
% plot(chiller_reactiveNCB_Tenv20.efficiency.effCoeff.time,chiller_reactiveNCB_Tenv20.efficiency.effCoeff,'color','r')
% xlabel('Time (s)')
% ylabel('\epsilon_{chill}')
% title('Chiller Efficiency')
% legend('AMPC','Reactive','ReactiveNCB')
% % return
% 
% 
% %% TWO PHASES DIAGRAMs
% 
% component = 1
% situation = 1
% open("doublPhase1.fig")
% if component == 1
%     if situation == 1 
%         hold on
%         plot(compressor.fluid.u.in,compressor.fluid.p.in,'Color',"b")
%         hold on
%         plot(compressor.fluid.u.out,compressor.fluid.p.out,'Color','k')
%     elseif situation == 2
%         hold on
%         plot(compressor_reactive_Tenv20.fluid.u.in,compressor_reactive_Tenv20.fluid.p.in,'Color',"b")
%         hold on
%         plot(compressor_reactive_Tenv20.fluid.u.out,compressor_reactive_Tenv20.fluid.p.out,'Color','k')
%     elseif situation == 3
%         hold on
%         plot(compressor_reactiveNCB_Tenv20.fluid.u.in,compressor_reactiveNCB_Tenv20.fluid.p.in,'Color',"b")
%         hold on
%         plot(compressor_reactiveNCB_Tenv20.fluid.u.out,compressor_reactiveNCB_Tenv20.fluid.p.out,'Color','k')
%     end
% elseif component == 2
%     if situation == 1
%         hold on
%         plot(condenser.TwoP.u.in,condenser.TwoP.p.in,'Color',"b")
%         hold on
%         plot(condenser_originalModel_Tenv20.TwoP.u.out,condenser_originalModel_Tenv20.TwoP.p.out,'Color','k')
%     elseif situation == 2
%         hold on
%         plot(condenser_reactive_Tenv20.TwoP.u.in,condenser_reactive_Tenv20.TwoP.p.in,'Color',"b")
%         hold on
%         plot(condenser_reactive_Tenv20.TwoP.u.out,condenser_reactive_Tenv20.TwoP.p.out,'Color','k')
%     elseif situation == 3
%         hold on
%         plot(condenser_reactiveNCB_Tenv20.TwoP.u.in,condenser_reactiveNCB_Tenv20.TwoP.p.in,'Color',"b")
%         hold on
%         plot(condenser_reactiveNCB_Tenv20.TwoP.u.out,condenser_reactiveNCB_Tenv20.TwoP.p.out,'Color','k')
%     end
% elseif component == 3
%     if situation == 1
%         hold on
%         plot(chiller.TwoP.u.in,chiller.TwoP.p.in,'Color',"b")
%         hold on
%         plot(chiller_originalModel_Tenv20.TwoP.u.out,chiller_originalModel_Tenv20.TwoP.p.out,'Color','k')
%     elseif situation == 2
%         hold on
%         plot(chiller_reactive_Tenv20.TwoP.u.in,chiller_reactive_Tenv20.TwoP.p.in,'Color',"b")
%         hold on
%         plot(chiller_reactive_Tenv20.TwoP.u.out,chiller_reactive_Tenv20.TwoP.p.out,'Color','k')
%     elseif situation == 3
%         hold on
%         plot(chiller_reactiveNCB_Tenv20.TwoP.u.in,chiller_reactiveNCB_Tenv20.TwoP.p.in,'Color',"b")
%         hold on
%         plot(chiller_reactiveNCB_Tenv20.TwoP.u.out,chiller_reactiveNCB_Tenv20.TwoP.p.out,'Color','k')
%     end
% end
% 
% 
% 
% 
% 
% end
% 
